/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ResetDlg.cpp $
   Last Modification:
    $Author: Robert $
    $Modtime: 10.04.07 13:16 $
    $Revision: 2862 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Device Reset Dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      2        23.03.07    MT       CODSTART/WARMSTART selection included
      1        05.07.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ResetDlg.cpp
///   Device Reset Dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "ResetDlg.h"
#include "CifXTestDlg.h"

static struct CHANNEL_RESET_MODEStag
{
  LPCTSTR       szMode;
  unsigned long ulMode;
} s_atChannelResetModes[] =
{
  {_T("System Start"), CIFX_SYSTEMSTART},
  {_T("Channel Init"), CIFX_CHANNELINIT},
};

static struct SYSTEM_RESET_MODEStag
{
  LPCTSTR       szMode;
  unsigned long ulMode;
} s_atSystemResetModes[] =
{
  {_T("System Start"), CIFX_SYSTEMSTART},
  {_T("Boot Start"),   CIFX_BOOTSTART},
};

IMPLEMENT_DYNAMIC(CResetDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CResetDlg::CResetDlg(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CResetDlg::IDD, pParent, false)
  , m_ulTimeout(CIFX_TO_FIRMWARE_START)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CResetDlg::~CResetDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::DoDataExchange(CDataExchange* pDX)
{
  CBaseDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CB_RESET, m_cResetModeCtrl);
}


BEGIN_MESSAGE_MAP(CResetDlg, CBaseDialog)
  ON_CBN_SELCHANGE(IDC_CB_RESET, OnCbnSelchangeCbReset)
  ON_EN_KILLFOCUS(IDC_EDT_TIMEOUT, OnEnKillfocusEdtTimeout)
  ON_BN_CLICKED(IDC_BTN_RESET, OnBnClickedBtnReset)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// First Time dialog intialization. Fill Combobox control with reset modes
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CResetDlg::OnInitDialog()
{
  CBaseDialog::OnInitDialog();

  SetDlgItemInt(IDC_EDT_TIMEOUT, m_ulTimeout, FALSE);

  return TRUE;  // return TRUE unless you set the focus to a control
  // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
/// Reset Mode selection changed event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnCbnSelchangeCbReset()
{
  int iCurSel = m_cResetModeCtrl.GetCurSel();
  ASSERT(-1 != iCurSel);

  m_ulResetMode = (unsigned long)m_cResetModeCtrl.GetItemData(iCurSel);
}

/////////////////////////////////////////////////////////////////////////////
/// Timeout editing end event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnEnKillfocusEdtTimeout()
{
  CString csTemp;
  GetDlgItemText(IDC_EDT_TIMEOUT, csTemp);

  TCHAR* pszEnd = NULL;
  m_ulTimeout = _tcstoul(csTemp, &pszEnd, 10);

  csTemp.Format(_T("%u"), m_ulTimeout);
  SetDlgItemText(IDC_EDT_TIMEOUT, csTemp);
}

/////////////////////////////////////////////////////////////////////////////
/// Reset Button clicked event
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnBnClickedBtnReset()
{
  if(CcifXTestDlg::s_pcDevice)
  {
    CWaitCursor cWait;

    long lRet = CcifXTestDlg::s_pcDevice->Reset(m_ulResetMode, m_ulTimeout);

    CString csTemp;
    if(CIFX_NO_ERROR != lRet)
    {
      csTemp.Format(_T("0x%08X\r\n%s"),
                    lRet,
                    (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

    }
    SetDlgItemText(IDC_LASTERR, csTemp);
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Cyclic thread function (unused)
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::ThreadFunction()
{
}

/////////////////////////////////////////////////////////////////////////////
/// Device Change notification (unused)
///   \param pcDevice NULL if device was closed, otherwise device has changed
/////////////////////////////////////////////////////////////////////////////
void CResetDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  bool fSysDevice = false;
  if (NULL != pcDevice)
  {
    if (pcDevice->IsSystemDevice())
      fSysDevice = true;  
  }
  
  m_cResetModeCtrl.ResetContent();
  
  if (fSysDevice)
  {
    /* System channel modes */
    for(int iIdx = 0; iIdx < sizeof(s_atSystemResetModes) / sizeof(s_atSystemResetModes[0]); ++iIdx)
    {
      int iItem = m_cResetModeCtrl.AddString(s_atSystemResetModes[iIdx].szMode);
      m_cResetModeCtrl.SetItemData(iItem, s_atSystemResetModes[iIdx].ulMode);
    }
    
  } else
  {
    /* Communication channel modesh */
    for(int iIdx = 0; iIdx < sizeof(s_atChannelResetModes) / sizeof(s_atChannelResetModes[0]); ++iIdx)
    {
      int iItem = m_cResetModeCtrl.AddString(s_atChannelResetModes[iIdx].szMode);
      m_cResetModeCtrl.SetItemData(iItem, s_atChannelResetModes[iIdx].ulMode);
    }
  }  

  /* Select first entry */
  m_cResetModeCtrl.SetCurSel(0);
  OnCbnSelchangeCbReset();
}
